package w83b.w83bDAO;

import java.util.HashMap;
import java.util.List;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bCentroTrabajoBean;
import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bDatosEscrutiniosBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bListaEscrutiniosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;




// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIActasDAO.
 */
public interface W83bIActasDAO {
	
	/**
	 * Buscar actas.
	 *
	 * @param param the param
	 * @param contar the contar
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarActas(w83b.w83bBeans.W83bActasBean param,boolean contar)throws Exception;
	
	
	/**
	 * Obtener municipio.
	 *
	 * @param provincia the provincia
	 * @param municipio the municipio
	 * @return the string
	 * @throws Exception the exception
	 */
	public String obtenerMunicipio(String provincia,String municipio) throws Exception;
	
	/**
	 * @param provincia
	 * @return
	 * @throws Exception
	 */
	public String obtenerTerritorio(String provincia) throws Exception;
	
	
	/**
	 * Buscar convenio.
	 *
	 * @param param the param
	 * @return the w83b convenios bean
	 * @throws Exception the exception
	 */
	public W83bConveniosBean buscarConvenio(w83b.w83bBeans.W83bActasBean param)throws Exception;
	
	/**
	 * Buscar delegados.
	 *
	 * @param param the param
	 * @return the w83b datos escrutinios bean
	 * @throws Exception the exception
	 */
	public W83bDatosEscrutiniosBean buscarDelegados(w83b.w83bBeans.W83bActasBean param)throws Exception;
	
	/**
	 * Cargar centro trabajo.
	 *
	 * @param mapaResultado the mapa resultado
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List cargarCentroTrabajo(HashMap mapaResultado) throws Exception;
	
	/**
	 * Cargar colegios.
	 *
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List cargarColegios() throws Exception;
	
	/**
	 * Insertar diferencia.
	 *
	 * @param diferencia the diferencia
	 * @param acta the acta
	 * @param anyoActa the anyo acta
	 * @param territorioActa the territorio acta
	 * @param versionActa the version acta
	 * @param usuario the usuario
	 * @param idioma the idioma
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDiferencia(W83bListaDiferenciasBean diferencia,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception;
	
	/**
	 * Insertar escrutinio.
	 *
	 * @param escrutinio the escrutinio
	 * @param acta the acta
	 * @param anyoActa the anyo acta
	 * @param territorioActa the territorio acta
	 * @param versionActa the version acta
	 * @param usuario the usuario
	 * @param idioma the idioma
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarEscrutinio(W83bListaEscrutiniosBean escrutinio,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception;
	
	/**
	 * Insertar delegado.
	 *
	 * @param delegado the delegado
	 * @param acta the acta
	 * @param anyoActa the anyo acta
	 * @param territorioActa the territorio acta
	 * @param versionActa the version acta
	 * @param usuario the usuario
	 * @param idioma the idioma
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDelegado(W83bListaDelegadosBean delegado,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception;
	
	/**
	 * Insertar acta.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarActa(W83bActasBean acta,String pantalla) throws Exception;
	
	/**
	 * Insertar papeletas.
	 *
	 * @param acta the acta
	 * @param colegio the colegio
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarPapeletas(W83bActasBean acta,String colegio) throws Exception;
	
	/**
	 * Buscar preavisos.
	 *
	 * @param acta the acta
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarPreavisos(W83bActasBean acta) throws Exception;
	
	
	/**
	 * Buscar acta total.
	 *
	 * @param acta the acta
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarActaTotal(W83bActasBean acta) throws Exception;
	/**
	 * Detalle actas.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean detalleActas(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Buscar escrutinio.
	 *
	 * @param param the param
	 * @return the java.util. hash map
	 * @throws Exception the exception
	 */
	public java.util.HashMap buscarEscrutinio(w83b.w83bBeans.W83bActasBean param) throws Exception;
	/**
	 * Buscar escrutinio colegios.
	 *
	 * @param param the param
	 * @return the java.util. hash map
	 * @throws Exception the exception
	 */
	public java.util.HashMap buscarEscrutinioColegios(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Buscar diferencia.
	 *
	 * @param param the param
	 * @return the java.util. hash map
	 * @throws Exception the exception
	 */
	public java.util.HashMap buscarDiferencia(w83b.w83bBeans.W83bActasBean param) throws Exception;
	/**
	 * Buscar diferencia colegios.
	 *
	 * @param param the param
	 * @return the java.util. hash map
	 * @throws Exception the exception
	 */
	public java.util.HashMap buscarDiferenciaColegios(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Buscar lista delegados.
	 *
	 * @param param the param
	 * @return the java.util. hash map
	 * @throws Exception the exception
	 */
	public java.util.HashMap buscarListaDelegados(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Buscar papeletas.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarPapeletas(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Insertar docs actas.
	 *
	 * @param param the param
	 * @param idioma the idioma
	 * @param dni the dni
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDocsActas(w83b.w83bBeans.W83bDocBean param,String idioma,String dni) throws Exception;
	
	/**
	 * Carga tipos documento actas.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargaTiposDocumentoActas(HashMap param) throws Exception;
	
	/**
	 * Max cod doc adjunto.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodDocAdjunto() throws Exception;
	
	/**
	 * Obtener docs actas.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerDocsActas(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Descargar documento actas.
	 *
	 * @param param the param
	 * @return the w83b doc bean
	 * @throws Exception the exception
	 */
	public W83bDocBean descargarDocumentoActas(String param) throws Exception;
	
	/**
	 * Obtener actas parciales.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerActasParciales(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Obtener impugnaciones.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean obtenerImpugnaciones(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Obtener historial acta.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean obtenerHistorialActa(w83b.w83bBeans.W83bActasBean param)throws Exception;
	
	/**
	 * Obtener tramites actas.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean obtenerTramitesActas(W83bActasBean param)throws Exception;
	
	/**
	 * Obtener incidencias actas.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean obtenerIncidenciasActas(W83bActasBean param)throws Exception;
	
	/**
	 * Editar acta.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String editarActa(W83bActasBean acta) throws Exception;
	
	/**
	 * Existe escrutinio.
	 *
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeEscrutinio(w83b.w83bBeans.W83bListaEscrutiniosBean param) throws Exception;
	
	/**
	 * Existe diferencia.
	 *
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeDiferencia(w83b.w83bBeans.W83bListaDiferenciasBean param) throws Exception;
	
	/**
	 * Existe papeletas.
	 *
	 * @param param the param
	 * @param colegio the colegio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existePapeletas(W83bActasBean param,String colegio) throws Exception;
		/**
		 * Existe lista delegados.
		 *
		 * @param param the param
		 * @return true, if successful
		 * @throws Exception the exception
		 */
	public boolean existeListaDelegados(w83b.w83bBeans.W83bListaDelegadosBean param) throws Exception;
	
	/**
	 * Modificar diferencia.
	 *
	 * @param diferencia the diferencia
	 * @param usuario the usuario
	 * @return the string
	 * @throws Exception the exception
	 */
	public String modificarDiferencia(W83bListaDiferenciasBean diferencia,String usuario) throws Exception;
	
	/**
	 * Modificar escrutinio.
	 *
	 * @param escrutinio the escrutinio
	 * @param usuario the usuario
	 * @return the string
	 * @throws Exception the exception
	 */
	public String modificarEscrutinio(W83bListaEscrutiniosBean escrutinio,String usuario) throws Exception;
	
	/**
	 * Modificar delegado.
	 *
	 * @param delegado the delegado
	 * @param usuario the usuario
	 * @return the string
	 * @throws Exception the exception
	 */
	public String modificarDelegado(W83bListaDelegadosBean delegado,String usuario) throws Exception;
	
	/**
	 * Buscar delegados acta.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarDelegadosActa(w83b.w83bBeans.W83bActasBean param) throws Exception;
	
	/**
	 * Buscar acta nueva.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarActaNueva(W83bActasBean param) throws Exception;
	
	/**
	 * Buscar acta nueva.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarActaNuevaDatosCentro(W83bActasBean param) throws Exception;
	
	/**
	 * Anyadir historial tramitacion.
	 *
	 * @param param the param
	 * @param fechaRegistro the fecha registro
	 * @throws Exception the exception
	 */
	public void anyadirHistorialTramitacion(W83bActasBean param,String fechaRegistro) throws Exception;
	
	/**
	 * Insertar historial actas.
	 *
	 * @param acta the acta
	 * @param texto the texto
	 * @throws Exception the exception
	 */
	public void insertarHistorialActas(W83bActasBean acta,String texto)throws Exception;
	
	/**
	 * Borrar acta logico.
	 *
	 * @param param the param
	 * @param motivo the motivo
	 * @param fecha the fecha
	 * @param usuarioBean the usuario bean
	 * @param idioma the idioma
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarActaLogico(String param,String motivo,String fecha,W83bUsuarioXLNetsBean usuarioBean,String idioma,String version) throws Exception;
	
	/**
	 * Borrar escrutinios.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarEscrutinios(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	/**
	 * Borrar diferencias.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDiferencias(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	/**
	 * Borrar delegados.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDelegados(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	/**
	 * Borrar papeletas.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarPapeletas(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	/**
	 * Borrar docs adjuntos.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDocsAdjuntos(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	/**
	 * Borrar historial de tramitacion.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarHistorialTramitacion(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	
	/**
	 * Buscar historial tramitacion.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @param bean the bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean buscarHistorialTramitacion(W83bUsuarioXLNetsBean usuarioBean,String version, W83bActasBean bean) throws Exception;
	
	/**
	 * Borrar impugnaciones.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean,String version) throws Exception;
	
	/**
	 * Borrar acta fisico.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @param version the version
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarActaFisico(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception;
	
	/**
	 * Max cod acta.
	 *
	 * @param anyo the anyo
	 * @param territorio the territorio
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodActa(String anyo, String territorio)throws Exception;
	
	/**
	 * Contar actas.
	 *
	 * @param anyo the anyo
	 * @param territorio the territorio
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarActas(String anyo, String territorio)throws Exception;
	
	/**
	 * Existe acta.
	 *
	 * @param anyo the anyo
	 * @param territorio the territorio
	 * @param numActa the num acta
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActa(String anyo, String territorio, String numActa) throws Exception;
	
	/**
	 * Modificar preaviso.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String modificarPreaviso(W83bActasBean acta) throws Exception;
	
	/**
	 * Borrar acta preaviso.
	 *
	 * @param territ the territ
	 * @param anyo the anyo
	 * @param num the num
	 * @param usuarioBean the usuario bean
	 * @param idioma the idioma
	 * @return the string
	 * @throws Exception the exception
	 */
	public String borrarActaPreaviso(String territ, String anyo, String num,W83bUsuarioXLNetsBean usuarioBean,String idioma) throws Exception;
	
	/**
	 * Borrar docs actas.
	 *
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarDocsActas(W83bActasBean param) throws Exception;
	
	/**
	 * Buscar sindicatos actas.
	 *
	 * @param acta the acta
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarSindicatosActas(W83bActasBean acta)throws Exception;
	
	/**
	 * Detalle acta impugnacion.
	 *
	 * @param param the param
	 * @return the w83b actas bean
	 * @throws Exception the exception
	 */
	public W83bActasBean detalleActaImpugnacion(W83bActasBean param) throws Exception;
	
	/**
	 * Existe acta impug.
	 *
	 * @param anyo the anyo
	 * @param territorio the territorio
	 * @param numActa the num acta
	 * @param version the version
	 * @return boolean
	 * @throws Exception the exception
	 */
	public boolean existeActaImpug(String anyo, String territorio, String numActa, String version) throws Exception;
	
	/**
	 * Modificar papeletas.
	 *
	 * @param acta the acta
	 * @param colegio the colegio
	 * @return String
	 * @throws Exception the exception
	 */
	public String modificarPapeletas(W83bActasBean acta,String colegio) throws Exception;
	
	/**
	 * Borrar escrutinios colegio.
	 *
	 * @param acta the acta
	 * @param colegio the colegio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarEscrutiniosColegio(W83bActasBean acta,String colegio) throws Exception ;
	
	/**
	 * Borrar diferencias colegio.
	 *
	 * @param acta the acta
	 * @param colegio the colegio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDiferenciasColegio(W83bActasBean acta,String colegio) throws Exception;
	
	/**
	 * Borrar delegados.
	 *
	 * @param acta the acta
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDelegados(W83bActasBean acta) throws Exception;
	
	/**
	 * Borrar escrutinio.
	 *
	 * @param escrutinio the escrutinio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarEscrutinio(W83bListaEscrutiniosBean escrutinio) throws Exception;
	
	/**
	 * Borrar diferencia.
	 *
	 * @param diferencia the diferencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDiferencia(W83bListaDiferenciasBean diferencia) throws Exception;
	
	/**
	 * Borrar papeletas colegio.
	 *
	 * @param acta the acta
	 * @param colegio the colegio
	 * @return String
	 * @throws Exception the exception
	 */
	public String borrarPapeletasColegio(W83bActasBean acta,String colegio) throws Exception;
	
	/**
	 * Buscar Acta Por Centro Trabajo.
	 *
	 * @param centro the centro
	 * @return String
	 * @throws Exception the exception
	 */
	public String buscarActaPorCentroTrabajo(W83bCentroTrabajoBean centro) throws Exception;
	
	/**
	 * Editar acta reg def.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String editarActaRegDef(W83bActasBean acta) throws Exception;
	
	//	david 17/07/2013 Comision Masiva INI
	/**
	 * Editar acta Fecha  Comis.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	
	public String editarActaFechaComision(W83bActasBean acta) throws Exception;
//	david 17/07/2013 Comision Masiva FIN
	
	
//	david 24/07/2013 Comision Masiva INI
	/**
	 * Es baja el acta.
	 *
	 * @param acta the acta
	 * @return Boolean
	 * @throws Exception the exception
	 */
	
	public boolean blnActaBaja(W83bActasBean acta) throws Exception;
//	david 24/07/2013 Comision Masiva FIN	

	/**
	 * Buscar impugnacion.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarImpugnacion(W83bActasBean param) throws Exception;
	/**
	 * Buscar buscarIncidencias.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarIncidencias(W83bActasBean bean) throws Exception;
	
	/**
	 * Borrar historial impugnaciones.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarHistorialImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar auditoria impugnaciones.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarAuditoriaImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	public List validarIntervaloEleccionSindicalCtoTrabajo(String idCentroTrabajo,String idioma,String territorioActa, String anyoActa,String numActa) throws Exception;
	
	public String buscarFechaCierre (java.util.HashMap param) throws Exception;
	
	public boolean borrarHistorialActa(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	public List buscarPreavisosdeCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception;
	
	public void editarHistorialTramitacion(W83bActasBean param,String fechaRegistro) throws Exception;
	
	public void anyadirHistorialTramitacionFechaModificacion(W83bActasBean param,String fechaRegistro) throws Exception;
	
	public List buscarActaMaxVersionValidada(W83bActasBean param) throws Exception;
	
	public List buscarActaMaxVersionValidadaNoValidada(W83bActasBean param) throws Exception;
	
	public boolean borrarFisicoDelegados(W83bActasBean acta) throws Exception;
	
	public String buscarCentroTrabajoActa(String territorio, String anyo, String numActa, String version) throws Exception;
	
	public void descartarIncidenciaActa(String param,W83bUsuarioXLNetsBean usuarioBean,String idioma,String version) throws Exception;
	
	public boolean borrarDelegadoConcreto(W83bActasBean param,W83bListaDelegadosBean delegado,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Devuelve true si el acta pertenece a un centro de menos de treinta trabajadores
	 * @param anyo ao acta
	 * @param territorio territorio acta 
	 * @param numActa numer acta
	 * @param version version acta
	 * @return boolean
	 * @throws Exception the exception
	 */
	public boolean esActaMenorTreintaElectores(String anyo, String territorio, String numActa, String version) throws Exception;
	
	
	/**
    * Actualiza la informacin de acuse de recibo de una comunicacin de un acta
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception;
}
